<?php

namespace App\Http\Controllers\API\Therapists;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;
use App\Http\Requests\API\Therapists\TherapistServices\CreateRequest;
use App\Http\Resources\API\ServicesResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistServicesController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
        $this->middleware(['api','auth:api','verified','api_setting']);
        $this->middleware('therapist.api');
      // $this->middleware('permission:therapist_services.index');
      // $this->middleware('permission:therapist_services.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_services.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_services.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_services.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_services.import',['only' => ['import']])
      // $this->middleware('permission:therapist_services.update|therapist_services.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_services =  $therapist->therapist_services()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_services =  $therapist_services->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_services =  $therapist_services->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_services = $therapist_services->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_services = $therapist_services->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_services = $therapist_services->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_services = $therapist_services->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_services = $therapist_services->get();
        return $therapist_services;
      }
      $therapist_services = $therapist_services->paginate($req->perPage);
      $therapist_services = ServicesResource::collection($therapist_services)->response()->getData(true);

      return $therapist_services;
    }
    $therapist_services = ServicesResource::collection($therapist->therapist_services()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_services;
  }

  /********* FETCH ALL TherapistServices ***********/
    public function index()
    {
        $therapist_services =  $this->getter();
        $response = generateResponse($therapist_services,count($therapist_services['data']) > 0 ? true:false,'TherapistServices Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistServices FOR Search ***********/
   public function filter(Request $request){
     $therapist_services = $this->getter($request);
     $response = generateResponse($therapist_services,count($therapist_services['data']) > 0 ? true:false,'Filter TherapistServices Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistService ***********/
    public function store(CreateRequest $request)
    {
        $settings = generalSettings();
      $therapist = auth()->user()->therapist;
      try{
        DB::beginTransaction();
        $request->merge(['created_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        $data['image'] = uploadFile($request,'image','therapist_services');
        $data['audio'] = uploadFile($request,'audio','therapist_services');
        $data['video'] = uploadFile($request,'video','therapist_services');
        $therapist_service = $therapist->therapist_services()->create($data);
        $therapist_service->slug = Str::slug($therapist_service->name . ' ' . $therapist_service->id, '-');
        if($settings['auto_approve_therapist_service'] == 1){
            $therapist_service->is_approved = 1;
            $therapist_service->approved_at = now();
          }
        $therapist_service->save();
        $therapist_service->tags()->sync($request->tag_ids);
        DB::commit();
        $therapist_service = $therapist->therapist_services()->withAll()->find($therapist_service->id);
        $therapist_service = new ServicesResource($therapist_service);
      $response = generateResponse($therapist_service,true ,'TherapistServices Created Successfully',null,'collection');
      return response()->json($response, 200);
    }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show(Service $therapist_service)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_service->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_service = $therapist->therapist_services()->withAll()->find($therapist_service->id);
        if($therapist_service){
          $therapist_service = new ServicesResource($therapist_service);
          $response = generateResponse($therapist_service,true,'TherapistService Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistService Not Found',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistService ***********/
    public function update(CreateRequest $request, Service $therapist_service)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_service->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadFile($request,'image','therapist_services',$therapist_service->image);
        } else {
            $data['image'] = $therapist_service->image;
        }

        if ($request->audio) {
            $data['audio'] = uploadFile($request,'audio','therapist_services');
        } else {
            $data['audio'] = $therapist_service->audio;
        }

        if ($request->video) {
            $data['video'] = uploadFile($request,'video','therapist_services');
        } else {
            $data['video'] = $therapist_service->video;
        }
        $data['slug'] = Str::slug($data['name'] . ' ' . $therapist_service->id, '-');

        $therapist_service->update($data);
        $therapist_service->tags()->sync($request->tag_ids);
        DB::commit();
        $therapist_service = $therapist->therapist_services()->withAll()->find($therapist_service->id);
        $therapist_service = new ServicesResource($therapist_service);
        $response = generateResponse($therapist_service,true,'TherapistService Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
        catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }

    /********* UPDATE TherapistService Status***********/
    public function updateStatus(Request $request,Service $therapist_service){
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_service->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_service->update([
          'is_active' => $therapist_service->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistService Status Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }


    /********* DELETE TherapistService ***********/
    public function destroy(Request $request,Service $therapist_service)
    {
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_service->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
          if($therapist_service->trashed()) {
            $response = generateResponse(null,false ,'Already in Trash',null,'collection');
            return response()->json($response, 404);
          }
          else{
            $therapist_service->delete();
          }
          $response = generateResponse(null,true,'TherapistService Deleted Successfully',null,'object');
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /*********Permanently DELETE TherapistService ***********/
    public function destroyPermanently(Request $request,$therapist_service)
    {
      try{
        $therapist= auth()->user()->therapist;
        $therapist_service = $therapist->therapist_services()->withTrashed()->find($therapist_service);
        if($therapist_service){
            if($therapist_service->therapist_id != $therapist->id){
              $response = generateResponse(null,false ,'Not Found',null,'collection');
              return response()->json($response, 404);
            }
          if ($therapist_service->trashed()) {
            $therapist_service->forceDelete();
            $response = generateResponse(null,true,'TherapistService Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistService is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistService not found',null,'object');
        }
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /********* Restore TherapistService ***********/
    public function restore(Request $request,$therapist_service)
    {
      $therapist= auth()->user()->therapist;
      $therapist_service = $therapist->therapist_services()->withTrashed()->find($therapist_service);
          if ($therapist_service->trashed()) {
            $therapist_service->restore();
            $response = generateResponse(null,true,'TherapistService Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistService is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
